# Ansible-Role "ansible_lza_rosetta_app"

## Description

This role provides all necessary tasks to prepare Rosetta/Oracle servers for SLUBArchiv.

## Prerequisites

To use this role, the following software must be installed on your workstation:
* ansible

To deploy this role to a managed host, the following software must be installed on the target:
* Python3
* SSHd

Other roles required by this role can be easily installed using `ansible-galaxy` if necessary. As the roles reside in SLUB's local Git server instance, you might need a password for certain repositories despite most of them being publicly available. This command will install the required roles in the correct location so they are found in the search path:
```
	ansible-galaxy install -r requirements.yml -p ../
```

It is recommended to use this role with Red Hat Enterprise Linux VMs as prepared by the "ansible_lza_create_rhel_iso" and "ansible_lza_bootstrap_rhel_server" roles.

## Quick start

Most options already have sensible defaults in `ansible.cfg`. However, you can override these defaults using CLI options/flags if you want to. The flags can be combined if necessary, and most of them have long versions as well. Get more information using `ansible-playbook --help`.

To simply run the playbook, just call the `site.yml` playbook like this:
```
	ansible-playbook site.yml -u <username>
```

If you want to limit the execution to a subset of all hosts that are listed in the inventory, use the `-l` or `--limit` option like this:
```
	ansible-playbook site.yml -l <hostna*>
	ansible-playbook site.yml -l <hostname>
	ansible-playbook site.yml -l <hostname1>:<hostname2>:...
	ansible-playbook site.yml -l <inventory_group>
	ansible-playbook site.yml --limit=<hostna*>
```

If you do not have Vault password files in the directory above the role direcory, you have to give the Vault password before execution:
```
	ansible-playbook site.yml --ask-vault-pass
```

You can use your own inventory file by adding the `-i` or `--inventory=INVENTORY` option:
```
	ansible-playbook site.yml -i inventory.yml
	ansible-playbook site.yml --inventory=inventory.yml
```

Tasks in this role have been tagged to enable users to only run subsets of tasks. This can be leveraged to decrease run times or run only certain tasks after small changes.
To list all available tags, use:
```
	ansible-playbook site.yml --list-tags
```
You can then run only certain tagged tasks by using the `--tags` option:
```
	ansible-playbook site.yml -t tag1,tag2,...,tagN
	ansible-playbook site.yml --tags=tag1,tag2,...,tagN
```

## Testing the role

Tests have been implemented using the Molecule framework. The details on using the test suite are described below `molecule/`.

## Variables

Many variables have been "hidden" in encrypted Ansible Vaults. For security reasons, these Vaults are maintained in a separate private internal repository of SLUB's Git. However, in order to better understand the data within the vaults, you can find `\*.vault.example` files below the `vars/` directory.

If you work outside of SLUBArchive and have no access to the vault repository, make sure to put the necessary vaults in the expected paths at `../ansible_vaults/<ROLENAME>/`.

## git configuration

Just run the `setup_gitconfig.sh` script that comes with the repo to correctly setup all necessary local Git configurations.

## Author Information

If you have any comments or find bugs, please contact langzeitarchiv@slub-dresden.de or issue a pull request.
