#!/usr/bin/env bash

###########################################################################
# Script: Datenbank - Export der Rosetta Oracle DB
# erstellt am: 24.4.2013
# durch: S. Krug (SLUB Dresden; IT Abteilung Referat 3)
#
# Vorraussetzungen:
# 1. Angelegtes Backupverzeichnis: /backup_tmp
# 2. Oracle in entsprechenden Homeverzeichnis: /exlibris/app/oracle; da nicht Standard
# 3. Datenbank SID muss gesetzt sein: "dps3"
#
# Aufruf:
# $> su - oracle -c"/scripts/expdump_dps3.sh"
###########################################################################

# Environment setzen

DAY=$( date +%y%m%d%S%M%S );                               export DAY

## Oracle Umgebungsvariable setzen
ORACLE_SID="dps3";                                         export ORACLE_SID
# NLS_LANG=american_america.WE8ISO8859P1;                    export NLS_LANG
ORACLE_BASE="/exlibris/app/oracle";                        export ORACLE_BASE
ORACLE_HOME="/exlibris/app/oracle/product/12r1";           export ORACLE_HOME
ORACLE_DUMPFILE1="/exlibris-backup/DPS3/expdp/dumpfiles1"; export ORACLE_DUMPFILE1
## Zeichensaetze einstellen (normal ist bei Oracle Sql Client : US7ASCII character set eingestellt)
NLS_LANGUAGE=AMERICAN;                                     export NLS_LANGUAGE
NLS_CHARACTERSET=UTF8;                                     export NLS_CHARACTERSET
#NLS_NCHAR_CHARACTERSET=UTF8;                               export NLS_NCHAR_CHARACTERASET
NLS_LANG=American_America.UTF8;                            export NLS_LANG

## Oracle Pfad setzen
PATH="${PATH}:/exlibris/app/oracle/product/12r1/bin";      export PATH

# Export der Datenbank
(
	flock -n 9 || exit 1
	# … unter der Sperrung ausgeführte Befehle …
	if [[ ! -d "${ORACLE_DUMPFILE1}" ]]; then
		[[ ${DEBUG} ]] && echo "Creating dumpfile directory '${ORACLE_DUMPFILE1}'."
		if mkdir -p ${ORACLE_DUMPFILE1}; then
			echo "Dumpfile directory '${ORACLE_DUMPFILE1}' created."
		else
			echo "Could not create dumpfile directory '${ORACLE_DUMPFILE1}'. Exiting..." && exit 1
		fi
	fi
	expdp userid=system/oradba FULL=y CONTENT=all DIRECTORY=DPUMP_DIR1 DUMPFILE="expdp_${ORACLE_SID}.${DAY}.dmp" logfile="expdp_${ORACLE_SID}.${DAY}.log"
) 9>"${LOCKFILE}"

# Alte Versionen löschen
/usr/bin/find "$ORACLE_DUMPFILE1" -name "*.dmp*" -mtime +2 -exec rm {} \;
/usr/bin/find "$ORACLE_DUMPFILE1" -name "*.log*" -mtime +2 -exec rm {} \;
