#######################################################
# RMAN commands for use with rman_dps3_fullbackup.sh
#######################################################

### backup current configuration as suggested by https://docs.oracle.com/cd/B28359_01/backup.111/b28273/rcmsynta046.htm#RCMRF156
SPOOL LOG TO '/exlibris-backup/DPS3/autobackup/oracle_config.cfg'
SHOW ALL;
SPOOL LOG OFF;

### ENABLE LOGGING
SPOOL LOG TO '/var/log/oracle/rman.log' APPEND;
SET ECHO ON;

CONFIGURE CONTROLFILE AUTOBACKUP ON;
# Syntax: %F = C-DBID-YYYMMDD-Q; Q=hex number for the sequence
CONFIGURE CONTROLFILE AUTOBACKUP FORMAT FOR DEVICE TYPE DISK TO '/exlibris-backup/DPS3/autobackup/cf_sp_file_%F';
# This defines the number of files that can be read simultaneously by each channel. The MAXOPENFILES default is 8.
# CONFIGURE MAXOPENFILES TO 8;

CONFIGURE RETENTION POLICY TO RECOVERY WINDOW OF 3 DAYS;

SHOW ALL;
REPORT UNRECOVERABLE;

### actual backup
# Multisection für große Datafiles verwenden, so dass je Datafile mehrere Channels geöffnet werden können. (https://docs.oracle.com/database/121/RCMRF/rcmsynta006.htm#RCMRF107)
BACKUP SECTION SIZE 8G DATABASE PLUS ARCHIVELOG DELETE INPUT;
# BACKUP DATABASE PLUS ARCHIVELOG DELETE INPUT;
### NOTE: this step will do the following (as documented in https://docs.oracle.com/database/121/RCMRF/rcmsynta006.htm#GUID-73642FF2-43C5-48B2-9969-99001C52EB50__CHDCFGEI):
# Run an ALTER SYSTEM ARCHIVE LOG CURRENT statement.
# Run the BACKUP ARCHIVELOG ALL command. If backup optimization is enabled, then RMAN only backs up logs that have not yet been backed up.
# Back up the files specified in the BACKUP command.
# Run an ALTER SYSTEM ARCHIVE LOG CURRENT statement.
# Back up any remaining archived redo log files. If backup optimization is not enabled, then RMAN backs up the logs generated in step 1 plus all the logs generated during the backup.

# delete obsolete + report obsolete
DELETE FORCE NOPROMPT OBSOLETE;

# #controlfile/pfile backup
# # sicherung controlfile to $ORACLE_HOME/admin/dps3/udump
SQL 'ALTER DATABASE BACKUP CONTROLFILE TO TRACE';
#SQL "ALTER DATABASE BACKUP CONTROLFILE TO TRACE AS ''${TRACE}'' REUSE";
#SQL "CREATE PFILE=''/exlibris-backup/DPS3/dbs/pfiledps3.ora'' FROM SPFILE";

### Crosscheck
CROSSCHECK ARCHIVELOG ALL;
DELETE NOPROMPT EXPIRED ARCHIVELOG ALL;
DELETE NOPROMPT OBSOLETE RECOVERY WINDOW OF 3 DAYS;

CROSSCHECK BACKUP;
DELETE NOPROMPT EXPIRED BACKUP;
CROSSCHECK COPY;
DELETE NOPROMPT EXPIRED COPY;

### List Backup Result
LIST BACKUP;
LIST BACKUP SUMMARY;
LIST BACKUP RECOVERABLE;

### Report any Errors
REPORT UNRECOVERABLE;

### Test the restore
RESTORE DATABASE VALIDATE;
RESTORE SPFILE VALIDATE;
RESTORE ARCHIVELOG FROM TIME 'sysdate-1' VALIDATE;
RESTORE CONTROLFILE TO '/tmp' VALIDATE;

SET ECHO OFF
SPOOL LOG OFF;
