#!/usr/bin/env bash

# preparation
DEBUG=1
LOGFILE="/var/log/backup/oracle/trigger_oracle_backup_storage_lvl.log"
LOCKFILE="/var/log/backup/oracle/trigger_oracle_backup_storage_lvl.lock"
STORAGE_THRESHOLD=50            # in percent
STORAGE_FILL_LVL=$( df /exlibris-journal | tail -n 1 | tr -s ' ' | cut -d ' ' -f5  | cut -d "%" -f1 )

(
    flock --nonblock 900 || exit 2
    # ... unter der Sperrung ausgeführte Befehle ...

    # run backup if necessary
    if [[ $STORAGE_FILL_LVL -ge $STORAGE_THRESHOLD ]]; then
        [[   $DEBUG ]] && echo "$( date +%F\ %T): $STORAGE_FILL_LVL% fill level >= $STORAGE_THRESHOLD% threshold, backup run necessary." >> $LOGFILE
        [[ ! $DEBUG ]] &&                                 /home/oracle/rman_dps3_fullbackup.sh
        [[   $DEBUG ]] && echo "$( date +%F\ %T): running /home/oracle/rman_dps3_fullbackup.sh" >> $LOGFILE
    fi
) 900>${LOCKFILE}

exit 0

