#!/usr/bin/env bash

# checks the status of the dsmcad backup service

# copy plugin to the "/usr/lib/check_mk_agent/plugin" directory
# test it via: check_mk_agent | grep -v grep | grep -A 3 "<<<local>>>"

# REQUIREMENTS:
# - SystemD init system
# - IBM Spectrum Protect Backup Client (formerly known as IBM Tivoli Storage
#   Manager TSM client)

# TODO:
# - add cross-platform capabilities (Upstart, SysVinit, ...) if needed

scriptname=$( basename "${0}" ".sh" )
LOCKFILE="/var/lock/${scriptname}.lock"

status=3
itemname="dsmcad_status"
perf_values="-"

servicename="dsmcad"

# check if dsmcad is installed
BINARY="$( command -v ${servicename} )"
[[ ${BINARY} ]] || exit 1

# IMPORTANT: Set lock using "flock", NOT "touch"!!! It's atomic and doesn't have to be cleared after the script ran.
(
flock -n 9 ||exit 1
	systemctl status "${servicename}".service &>/dev/null; rc=$?

	if [[ ${rc} -eq 0 ]]; then
		status=0
		statustext="${servicename} is running."
	elif [[	${rc} -eq 3 ]]; then
		status=2
		statustext="${servicename} is NOT running! You might want to restart it using 'systemctl start ${servicename}'."
	else
		status=3
		statustext="Couldn't get ${servicename} status."
	fi

	echo "${status} ${itemname} ${perf_values} ${statustext}"
) 9>"${LOCKFILE}"

# Code checked by shellcheck (https://github.com/koalaman/shellcheck) on 2020-12-02
