#!/usr/bin/env bash

# Copy plugin to the "/usr/lib/check_mk_agent/plugin" directory
# Test it via: check_mk_agent | grep -v grep | grep -A 3 "<<<local>>>"

# REQUIREMENTS:
# - Bash 4 or higher
# - curl
# - Rosetta

SCRIPTNAME=$( basename "${0}" ".sh" )
LOCKFILE="/var/lock/${SCRIPTNAME}.lock"

status=3
itemname="rosetta_heartbeat_status"
perf_values="-"

ROSETTA_HTTPS_PORT="8443"
ROSETTA_HTTP_PORT="1801"
ROSETTA_HOST=$(hostname --fqdn)

# check if HTTPS is used, TRUE == 1
IS_HTTPS=$( lsof -i:8443 -sTCP:LISTEN | tail -n +2 | wc -l )
if [[ ${IS_HTTPS} == 1 ]]; then
    ROSETTA_PORT=${ROSETTA_HTTPS_PORT}
    PROTOCOL="https"
else
    ROSETTA_PORT=${ROSETTA_HTTP_PORT}
    PROTOCOL="http"
fi

HEADER_CONTENT="Content-type: text/xml; charset=\"utf-8\""
HEADER_CALL="SOAPAction:"
SOAP_ENVELOPE_PATH="$( dirname ${0} )/$( basename ${0} '.sh').xml"
SOAP_ENDPOINT_URL="${PROTOCOL}://${ROSETTA_HOST}:${ROSETTA_PORT}/dpsws/repository/DataManagerServicesWS?getHeartBit"
CALL="curl -s --header '${HEADER_CONTENT}' --header '${HEADER_CALL}' --data @${SOAP_ENVELOPE_PATH} ${SOAP_ENDPOINT_URL}"

# check if curl is installed
BINARY="$(command -v curl)"
[[ ${BINARY} ]] || exit 1

# IMPORTANT: Create lockfile using "flock", NOT "touch"!!! It's atomic and
# doesn't have to be cleared after the script ran.
# flock ${LOCKFILE} $CALL &>/dev/null; rc=$?
(
flock -n 9 || exit 1
    RESULT=$( bash -c "$CALL" )
    # echo "RESULT ===== '$RESULT'"

    if [[ "${RESULT}" =~ '<return>DataManagerServicesWSImpl</return>' ]]; then
        status=0
        statustext="Rosetta is running (got correct answer from the heartbeat API)."
	perf_values="rosetta_up=1"
    else
        status=2
        statustext="Rosetta is NOT running."
	perf_values="rosetta_up=0"
    fi

    echo "${status} ${itemname} ${perf_values} ${statustext}"
) 9>"${LOCKFILE}"
