# https://docs.pytest.org/en/latest/parametrize.html#pytest-mark-parametrize-parametrizing-test-functions


@pytest.mark.parametrize("name,version", [
    ("python", "2.7"),
])
def test_configure_yum_repositories(host):
    print("not implemented")


def test_configure_iptables_qos(host):
    ipt_pre = host.iptables.rules("mangle", "PREROUTING")
    print(ipt_pre)
    ipt_post = host.iptables.rules("mangle", "POSTROUTING")
    print(ipt_post)


@pytest.mark.parametrize("mountpoint", [
    {'path': "/exlibris", 'device': ""},
    {'path': "/operational_shared", 'device': ""},
    {'path': "/operational_storage", 'device': ""},
    {'path': "/permanent_storage", 'device': ""}
])
def test_configure_nfs_mounts(host):
    mount = host.mount_point(mountpoint)
    assert mount.exists
    assert mount.device == mount(device)
    assert mount.filesystem == "nfs"


@pytest.mark.parametrize("rman_file", [
    "/home/oracle/expdump_dps3.sh",
    "/home/oracle/impdump_dps3.sh",
    "/home/oracle/rman_backup.cmd",
    "/home/oracle/trigger_oracle_backup_storage_lvl.sh",
    "/home/oracle/tsm_error_mail.sh",
    "/home/oracle/rman_dps3_fullbackup.sh"
])
def test_configure_rman_backup(host):
    d = host.file("/var/log/oracle")
    assert d.exists
    assert d.is_directory
    assert d.mode == 0o750
    f = host.file(f"/home/oracle/{rman_file}")
    assert f.exists
    assert f.is_file
    assert f.mode == 0o755


def test_configure_selinux(host):
    f = host.file("/etc/selinux/config")
    assert f.exists
    assert f.if_file
    assert f.user == "root"
    assert f.group == "root"
    assert f.mode == 0o644
    assert f.contains("SELINUX=permissive")
    assert f.contains("SELINUXTYPE=targeted")
    assert f.md5sum == "edb80f9889245e2f31b3d6ab33684b1a"


@pytest.mark.parametrize("tsm_file", [
    "dsm.sys",
    "dsm.opt"
])
def test_configure_tsmclient(host):
    f = host.file(f"/opt/tivoli/tsm/client/ba/bin/{tsm_file}")
    assert f.exists
    assert f.is_file
    assert f.user == "root"
    assert f.group == "root"
    assert f.mode == 0o644
    s = host.service("dsmcad")
    assert s.is_running
    assert s.is_enabled


@pytest.mark.parametrize("check_mk_plugin", [
    "checkmk_dsmcad.sh",
    "check_oracle_db_segment_size.sh",
    "mk_inventory",
    "mk_logwatch",
    "mk_oracle"
])
def test_install_checkmk_plugins(host):
    f = host.file(f"/usr/lib/check_mk_agent/plugins/{check_mk_plugin}")
    assert f.exists
    assert f.is_file
    assert f.user == "root"
    assert f.group == "root"
    assert f.mode == 0o750


def test_install_packages(host):
    print(f"RELEASE: '{host.systeminfo.release}'")
    print(f"CODENAME: '{host.systeminfo.codename}'")
    if host.systeminfo.release == "6":
        from parameter_files import redhat_6_packages
    else:
        from parameter_files import redhat_7_packages
    pkg = host.package(name)
    assert pkg.is_installed
    assert pkg.version.startswith(version)


@pytest.mark.parametrize("sql_scripts", [
    "create_user_dbsnmp.sql",
    "create_user_nagios.sql",
    "qry_workers_conf.sql"
])
def test_install_sql_scripts(host):
    d = host.file("/home/oracle/sql-scripts")
    assert d.exists
    assert d.is_directory
    assert d.mode == 0o644
    f = host.file(f"/home/oracle/sql-scripts/{sql_scripts}")
    assert f.exists
    assert f.is_file
    assert f.mode == 0o644
