#!/usr/bin/env bash
set -ex

# Change the path that Git expects the hooks to be in, so we can track the hooks
# within the repository (as the default `.git/` directory is not tracked).
git config --local core.hooksPath .githooks/

# To be able to run `git diff` on Ansible Vault files, please set you local
# `git/config` files as described in (https://stackoverflow.com/a/52863794) for
# the `~/.gitconfig` file or just blindly follow the instructions there to set
# it for you Git installation as a whole.
git config --local core.attributesfile "../.gitattributes"
git config --local diff.ansible-vault.textconv "ansible-vault view"
