use strict;
use warnings;
package SLUB::LZA::Rosetta::TA;
use App::Cmd::Setup -app;
use Path::Tiny qw( path );
use YAML qw(LoadFile);
use LWP::UserAgent;
use Carp qw( croak );
use feature qw(say);
use Regexp::Optimizer;
use IO::Zlib;


our %config;
BEGIN{
    my $home = path($ENV{'HOME'});
    if ($home->is_dir() && !$home->is_rootdir) {
        my $config_path = $home->child('.config')->child('ta-tool.rc');
        our $config_file = $config_path;
        if ($config_path->is_file) {
            if (1) { say "DEBUG: loading config from '$config_file'"; }
            %config = YAML::LoadFile($config_path);
        }
    }
}

sub sru_search {
    my $searchtype = shift;
    my $query = shift;
    my $startrecord = shift;
    my $maxrecords = shift;
    my $is_verbose = shift;
    my %searchpaths = (
        ie   => 'permanent/ie',
        file => 'permanent/file',
        sip  => 'operational'
    );

    if (!exists $searchpaths{$searchtype}){
        croak ("Code error, wrong searchtype ($searchtype) used!");
    }
    my $protocol = 'https';
    my $host = $config{host};
    my $port = '8443';
    my $searchpath = $searchpaths{$searchtype};
    my $srubase="${protocol}://${host}:${port}/search/${searchpath}/sru";
    my $sru = "${srubase}?version=1.2&operation=searchRetrieve&startRecord=$startrecord&maximumRecords=$maxrecords&recordSchema=dc&query=${query}";
    my $ua = LWP::UserAgent->new(keep_alive => 1);
    $ua->agent("MyApp/0.1 ");
    $ua->timeout(3600);#1h
    $ua->default_headers->push_header('Accept-Encoding' => 'br, lzma, bzip2, gzip, compressed, deflate');
    $ua->ssl_opts(
        verify_hostname=>1,
        # SSL_ca_path => '/etc/ssl/',
    );
    if ($is_verbose) {
        say "searchurl = $sru";
    }
    my $req = $ua->get($sru);
    if ($req->is_success) {
        my  $xres = $req->decoded_content;
        return $xres;
    } else {
        croak ("Error was: ".$req->status_line());
    }

}

sub scan_log {
    my $date_rx=shift;
    my $level_rx=shift;
    my $match_rx=shift;
    my $output_filter=shift;
    # open dir from config{$logdir}
    # for all files matching server.log*; do
    #   read lines
    #   filter lines
    #   return
    my $directory = path($config{logdir});
    my $search_rxo = Regexp::Optimizer->new->optimize(qr/^$date_rx [^ ]* $level_rx  (.*?)$match_rx(.*?)$/);
    for ($directory->children( qr/^server.log/ )) {
        my $file = $_;
        if (!$file->is_file) { next; }
        my $fh;
        if ($file =~ m/\.gz$/) {
            $fh = IO::Zlib->new("$file", "rb");
        } else {
            $fh = $file->openr;
        }
        if (defined $fh) {
            while(<$fh>) {
                chomp;
                if (! m/$search_rxo/) {
                    #print "no match for '$_'";
                    next;
                }
                my $line = $output_filter->( $_ );
                say $line;
            }
        }
        undef $fh;
    }
}

1;
