package SLUB::LZA::Rosetta::TA::Command::init;
use strict;
use warnings;
use SLUB::LZA::Rosetta::TA -command;
use YAML qw(DumpFile);
use feature qw(say);

sub abstract {"Initialize $0";}
sub description {"Initialize $0, preparing config"}
sub opt_spec {
    return(
        ["verbose|v" => "enable verbose output"],
        ["rosettahost|r=s" => "host adress where Rosetta runs", {required=>1}],
        ["logdir|l=s" => "logdir where rosetta stores it server log files", {required=>1}],
    );
}
sub validate_args {
    my ($self, $opt, $args) = @_;
    # no args allowed but options!
    $self->usage_error("No args allowed") if @$args;
}

sub execute {
    my ($self, $opt, $args) = @_;
    my %config;
    $config{host} = $opt->{rosettahost};
    $config{logdir} = $opt->{logdir};
    if (defined $SLUB::LZA::Rosetta::TA::config_file) {
        if (defined $opt->{verbose}) {
            say "store config in $SLUB::LZA::Rosetta::TA::config_file";
        }
        YAML::DumpFile($SLUB::LZA::Rosetta::TA::config_file, %config);
    }
}

1;