#!/usr/bin/env perl
use strict;
use warnings;
use SLUB::LZA::TA;
SLUB::LZA::TA->run;

# VERSION

# ABSTRACT: binary ta-tool

=head1 NAME

ta-tool - the swiss knife for the technical analyst working with different Achival Information systems

=head1 SYNOPSIS

    ta-tool <command> [options]

 COMMANDS:

      help: display a command's help screen

     count: count AIPs in Archival Information System (AIS)
      info: information about Archival Information System (AIS)
      init: Initialize bin/ta-tool.pl
    report: print AIP reports about Archival Information System (AIS)
    search: searches Archival Information System (AIS)

 OPTIONS:
    -v --verbose             Show more detailed option
    -h --help                Prints this help information
    -D --debug               Show user agent debug information
    -e --elasticsearch_host   Host adress where Archivematica's ElasticSearch runs, overrides config value (optional)
    -E --elasticsearch_port   Port number where Archivematica's ElasticSearch runs, overrides config value (optional)

=head1 DESCRIPTION

The tool allows you to submit queries to Archivematica's ElasticSearch, which makes your daily work as a technical analyst much easier.

=head1 HINTS

command 'report' with options '--with-ldp' and '--with-filetypes' should be used with care because the running time
      increases from O(n) to O(n²) if one option is used
      or increases to O(n³) if both options used
      (with n => count of AIPs)

ensure the ElasticSearch server allows to return >10.000 results if your archive is large, especially if you use
file-specific options like '--pronom-id' or '--with-filetypes'.


=head1 COPYRIGHT AND LICENSE

Copyright by Andreas Romeyke, free licensed under General Public License v3 or higher, see file LICENSE for details.

=cut


1;
