package SLUB::LZA::TA::Archivematica::Elasticsearch;
# contains stuff related to Artefactuals Archivematica
# Andreas Romeyke (romeyke@slub-dresden.de)
# HINT: the server is v6.x.y of elasticsearch, therefore this code is using old client
use v5.36;
use namespace::autoclean -except => qr{import};
use Data::Printer;
use Search::Elasticsearch 6.81; # install with: cpanm Search::Elasticsearch~"<7.0"
use Search::Elasticsearch::Client::6_0;

use Exporter 'import';
our @EXPORT = qw(
    version_elasticsearch
    query_elasticsearch_count
    query_elasticsearch
);
our @EXPORT_OK = qw();

#$Search::Elasticsearch::Error::DEBUG=2;

sub _instantiate($protocol, $host, $port) {
    return Search::Elasticsearch->new(
        nodes    => "$protocol://$host:$port",
        #trace_to => 'Stderr',
        #cnx_pool => 'Sniff',
        cxn_pool => 'Static::NoPing',
        client => '6_0::Direct'
    );
}

sub version_elasticsearch($protocol, $host, $port) {
    my $e = _instantiate($protocol, $host, $port);
    my $info = $e->info;
    return $info->{version}->{number};
}

sub query_elasticsearch($protocol, $host, $port, $index_name, $query_hash, $options=undef) {
    # HINT: filter_paths not well supported

    # next lines to deep copy hash, to avoid sideeffects in caller
    my $local_query_hash;
    foreach my $key (keys %{$query_hash} ) {
        $local_query_hash->{$key} = $query_hash->{$key}
    }
    if (defined $options) {
        if (exists $options->{no_source} and defined $options->{no_source} and $options->{no_source} == 1) {
            $local_query_hash->{_source} = "false"; # avoids transfering complete source tree in results
        }
        else {
            #$local_query_hash->{_source}->{excludes}=""
        }
        if (exists $options->{debug} and defined $options->{debug} and $options->{debug} == 1) {
            say STDERR "query:";
            say STDERR "------------------------";
            say STDERR np($query_hash);
            say STDERR "------------------------";
        }
    }
    my $e = _instantiate($protocol, $host, $port);

    my $res = $e->search(
        index => $index_name,
        body  => $local_query_hash, #hashref
    );
    if (exists $options->{debug} and defined $options->{debug} and $options->{debug} == 1) {
        say STDERR "response:";
        say STDERR "------------------------";
        say STDERR np($res);
        say STDERR "------------------------";
    }
    return $res;
}

sub query_elasticsearch_count($protocol, $host, $port, $index_name, $query_hash, $options=undef) {
    $options->{ no_source } = 1;
    my $res = query_elasticsearch($protocol, $host, $port, $index_name, $query_hash, $options);
    return $res->{hits}->{total};
}




# vim: set tabstop=4
1;
