package SLUB::LZA::TA::Archivematica::Elasticsearch::PrepareQuery;
use v5.36;
use namespace::autoclean;

sub prepare_aip_query ($opt) {
    my $query;
    my @must;
    my @must_not;
    my @should;
    my %recipe;
    $recipe{startrecord} =sub {
        $query->{from} = $opt->{startrecord} - 1; # start from index 0 -> first record
    };
    $recipe{maxrecords} =sub {
        $query->{size} = $opt->{maxrecords};
    };
    $recipe{aip} =sub {
        push @must, {
            "match_phrase" => {
                "uuid" => "$opt->{aip}"
            }
        };
    };
    $recipe{lzaid} =sub {
        push @must, {
            "match_phrase" => {
                "transferMetadata.bim:bag-info_dict.bim:SLUBArchiv-lzaId" => "$opt->{lzaid}"
            }
        };
    };
    $recipe{only_migrated} =sub {
        push @must, {
            "exists" => {
                field => "transferMetadata.bim:bag-info_dict.bim:SLUBArchiv-migrated-AIP"
            }
        }
    };
    $recipe{only_updated} =sub {
        push @must, {
            "exists" => {
                field => "transferMetadata.bim:bag-info_dict.bim:SLUBArchiv-previous-AIP"
            }
        }
    };
    $recipe{only_new} =sub {
        push @must_not, {
            "exists" => {
                field => "transferMetadata.bim:bag-info_dict.bim:SLUBArchiv-previous-AIP"
            }
        }
    };
    $recipe{only_ldp_project} =sub {
        push @must, {
            "match_phrase" => {
                "transferMetadata.bim:bag-info_dict.bim:LDP-project" => $opt->{only_ldp_project}
            }
        }
    };
    $recipe{only_ldp_saxon} =sub {
        push @must, {
            "match_phrase" => {
                "transferMetadata.bim:bag-info_dict.bim:LDP-funder" => 'LDP Sachsen'
            }
        }
    };
    $recipe{only_ldp_without_saxon} =sub {
        push @must_not, {
            "match_phrase" => {
                "transferMetadata.bim:bag-info_dict.bim:LDP-funder" => 'LDP Sachsen'
            }
        };
        push @must, {
            "exists" => {
                field => "transferMetadata.bim:bag-info_dict.bim:LDP-funder"
            }
        }
    };
    $recipe{only_ldp} =sub {
        push @must, {
            "exists" => {
                field => "transferMetadata.bim:bag-info_dict.bim:LDP-funder"
            }
        }
    };
    $recipe{no_ldp} =sub {
        push @must_not, {
            "exists" => {
                field => "transferMetadata.bim:bag-info_dict.bim:LDP-funder"
            }
        }
    };
    $recipe{descriptive} =sub {
        #https://opster.com/guides/elasticsearch/search-apis/elasticsearch-match-multi-match-and-match-phrase-queries/#Multi-match-query
        push @should, {
            "multi_match" => {
                "query" => "$opt->{descriptive}",
                "fields" => ["transferMetadata.*"] # scan all metadata, exact match
            }
        }
    };
    $recipe{fuzzy} =sub {
        push @should, {
            "multi_match" => {
                "query" => "$opt->{fuzzy}",
                "fields" => ["transferMetadata.*"], # scan all metadata, phrase match
                "type" => "phrase_prefix",
            }
        }
    };
    $recipe{creationdate_epochs} =sub {
        push @must, {
            "range" => {
                "created" => {
                    "gte" => $opt->{creationdate_epochs}->{from},
                    "lt"  => $opt->{creationdate_epochs}->{to},
                }
            }
        };
    };
    $recipe{modificationdate} =sub {
        #push @queries, "FILE.objectCharacteristics.modificationDate==$opt->{modificationdate}";
    };
    $recipe{workflow} =sub {  # LZA Workflow search
        push @must, {
            "match_phrase" => {
                "transferMetadata.ObjectType_dict.Metadata_dict.WorkflowName" => $opt->{workflow}
            }
        };
    };
    foreach my $key (keys %{ $opt } ) {
        if (defined $recipe{$key} and ref $recipe{$key} eq 'CODE') {
            $recipe{$key}->();
        }
    }
    if (scalar @must > 0) {
        $query->{query}->{bool}->{must} = \@must ;
    }
    if (scalar @must_not > 0) {
        $query->{query}->{bool}->{must_not} = \@must_not ;

    }
    if (scalar @should > 0) {
        $query->{query}->{bool}->{should} = \@should ;
    }

    if (exists $opt->{debug}) {
        use Data::Printer;
        say STDERR "\@must=",np(@must);
        say STDERR "\@must_not=", np(@must_not);
        say STDERR "\@should=",np(@should);
    }
    return $query;
}

sub prepare_files_query {
    my ($self, $opt, $args) = @_;
    if (exists $opt->{pronom_id}) {
        my $pronom_id = $opt->{pronom_id};
        my $files_query = {
            query     => {
                bool => {
                    must =>
                        [
                            {
                                match_phrase => {
                                    join(".", qw(
                                        METS
                                        amdSec
                                        mets:amdSec_dict
                                        mets:techMD_dict
                                        mets:mdWrap_dict
                                        mets:xmlData_dict
                                        premis:object_dict
                                        premis:objectCharacteristics_dict
                                        premis:format_dict
                                        premis:formatRegistry_dict
                                        premis:formatRegistryKey
                                    )
                                    ) => "$pronom_id"
                                    #"METS.amdSec.mets:amdSec_dict.mets:techMD_dict.mets:mdWrap_dict.mets:xmlData_dict.premis:object_dict.premis:formatRegistry_dict.premis:formatRegistryKey" => "$pronom_id"
                                    #"premis:formatRegistryKey" => "$pronom_id"
                                }
                            }
                        ],
                }
            },
            "size"    => 10000,
            "_source" => {
                "includes" => 'AIPUUID'
            }
        };
        return $files_query;
    }
    return;
}

sub prepare_ldpprojects_query {
    my ($self, $opt, $args) = @_;
    my $ldpprojects_query = {
        query     => {
            bool => {
                must =>
                    [
                        {
                            "exists" => {
                                field => "transferMetadata.bim:bag-info_dict.bim:LDP-project"
                            }
                        }
                    ],
            }
        },
        "size"    => 10000,
        "_source" => {
            "includes" => 'transferMetadata.bim:bag-info_dict.bim:LDP-project'
        }
    };
    if (exists $opt->{creationdate_epochs}) {
        my @must = @{ $ldpprojects_query->{query}->{bool}->{must} };
        push @must,
            { "range" =>
                {
                    "created" => {
                        "gte" => $opt->{creationdate_epochs}->{from},
                        "lt"  => $opt->{creationdate_epochs}->{to},
                    }

                }
            };
        $ldpprojects_query->{query}->{bool}->{must}=\@must;
    };
    return $ldpprojects_query;
}

1;
