package SLUB::LZA::TA::Command::info;
use SLUB::LZA::TA -command;
use v5.36;
use SLUB::LZA::TA::Archivematica::Elasticsearch;
use namespace::autoclean;
# VERSION

# ABSTRACT: search IEs module for ta-tool

sub abstract {return "information about Archival Information System (AIS)";}

my $description=<<"DESCR";
Reports information about AIS

DESCR

sub description {
    return "$description"
}
sub opt_spec {
    my @global_opts= SLUB::LZA::TA::common_global_opt_spec();
    my @local_opts = (
        [ 'target-version|T' => 'get current elasticsearch version'],
        [ 'version|V', 'print '.$0.' version information'],
    );
    return (@global_opts, [], @local_opts);
}
sub validate_args {
    my ($self, $opt, $args) = @_;
    SLUB::LZA::TA::common_global_validate($self, $opt, $args);
    # no args allowed but options!
    $self->usage_error("No args allowed") if @$args;
    return 1;
}

sub execute {
    my ($self, $opt, $args) = @_;
    if ($opt->{target_version}) {
        say SLUB::LZA::TA::Archivematica::Elasticsearch::version_elasticsearch(
            $SLUB::LZA::TA::config{elasticsearch_protocol},
            $SLUB::LZA::TA::config{elasticsearch_host},
            $SLUB::LZA::TA::config{elasticsearch_port}
        );
    }
    if ($opt->{version}) {
        say $SLUB::LZA::TA::VERSION;
    }
    return 1;
}

1;
