package SLUB::LZA::TA::Output;
use v5.36;
use utf8;
use List::Util qw(any none);
use SLUB::LZA::TA::Output::Asciidoc;
use SLUB::LZA::TA::Output::CSV;
use SLUB::LZA::TA::Output::RSV;
use SLUB::LZA::TA::Output::Raw;
use namespace::autoclean -except => qr{SLUB::LZA::TA::.*};


# VERSION

# ABSTRACT: search IEs module for ta-tool

sub add_line_by_baginfo_entry ($lineref, $partial_result, $key, $opt) {
    my $linekey = lc($key); $linekey=~s/-/_/g;
    my $optionkey = lc("with_".$key); $optionkey=~s/-/_/g;
    if (exists $opt->{$optionkey}) {
        my $tfm = $partial_result->{_source}->{transferMetadata}->[0];
        my $bid;
        if (ref $tfm->{'bim:bag-info_dict'} eq 'ARRAY') {
            my @tfms = @{ $tfm->{'bim:bag-info_dict'} };
            $bid = $tfm->{'bim:bag-info_dict'}[$#tfms]; # use only latest entry, because newest AIP version after MD Update!
        } else {
            $bid = $tfm->{'bim:bag-info_dict'};
        }
        if (exists($bid->{ "bim:$key" }) ) {
            $lineref->{$linekey} = $bid->{ "bim:$key" };
        } else {
            #   use Data::Printer;
            #say "$t -->";
            #say np($tfm);
        }
    }
    return 1;
}

sub line_result_mapper {
    my ($partial_result, $opt) = @_;
    my %line;
    $line{aipid}= $partial_result->{_source}->{uuid};
    foreach my $t (qw(
        External-Description
        External-Identifier
        LDP-collection
        LDP-funder
        LDP-lender
        LDP-project
        Payload-Oxum
        SLUBArchiv-archivalValueDescription
        SLUBArchiv-exportToArchiveDate
        SLUBArchiv-externalId
        SLUBArchiv-externalIsilId
        SLUBArchiv-externalWorkflow
        SLUBArchiv-hasConservationReason
        SLUBArchiv-lzaId
        SLUBArchiv-migrated-AIP
        SLUBArchiv-origin-AIS
        SLUBArchiv-previous-AIP
        SLUBArchiv-rightsVersion
        SLUBArchiv-sipVersion
        Title
    )
    ) {
        add_line_by_baginfo_entry(\%line, $partial_result, $t, $opt);
    }
    my $payload_oxum = $line{'payload_oxum'};
    my $payload_size = "";
    my $payload_filecount = "";
    ($payload_size, $payload_filecount) = split /\./, $payload_oxum if (defined $payload_oxum);
    $line{payload_size} = $payload_size if (defined $opt->{with_payload_size});
    $line{payload_filecount} = $payload_filecount if (defined $opt->{with_payload_filecount});
    delete $line{'payload_oxum'}; # should not be part of result!
    $line{creation_date} = $partial_result->{_source}->{created} if (defined $opt->{with_creationdate});;
    $line{filecount} = $partial_result->{_source}->{file_count} if (defined $opt->{with_filecount});;
    $line{path} = $partial_result->{_source}->{filePath} if (defined $opt->{with_path});;
    $line{score} = $partial_result->{_score} if (defined $opt->{with_score});
    $line{size} = $partial_result->{_source}->{size} * 1024 * 1024 if (defined $opt->{with_size});;
    return \%line;
}

sub get_headers($result_ref) {
    my %tmpheaders;
    foreach my $line (@{$result_ref}) {
        foreach my $k (keys %{ $line }) {
            $tmpheaders{$k}=1;
        }
    };
    my @headers = sort keys (%tmpheaders);
    return \@headers;
}

sub print_results ($aips_response, $opt) {
    # print pagination to STDERR
    my $all = $aips_response->{hits}->{total};
    my $from = $opt->{startrecord} || 1;
    my $to = $all > $opt->{maxrecords} ? ($opt->{maxrecords} + $from -1) : ($all + $from -1);

    my $idx = $from;

    my @result = map {
        my $tmp_new = line_result_mapper($_, $opt);
        if (defined $opt->{with_result_index}) {
            $tmp_new->{_idx} = $idx++;
        }
        $tmp_new;
    } @{$aips_response->{hits}->{hits}};

    my $aip_only = List::Util::none {$_ =~ m/^with/} keys %{$opt};
    if (!exists $opt->{output_format}) {
        if ($aip_only) {
            $opt->{output_format} = 'output_as_csv'
        }
        else {
            $opt->{output_format} = 'output_as_rsv';
        }
      }
    say STDERR "found $all result" . ($all != 1 ? 's'  : '');
    if ($all > 0) {
        my $output_format_human = $opt->{output_format}; $output_format_human =~ s/_/ /g;
        say STDERR "reporting results". ($from != $to ? " $from … $to " : " ")."$output_format_human";
    }
    if ($opt->{output_format} eq 'output_as_csv') {
        SLUB::LZA::TA::Output::CSV::print_results(\@result);
    } elsif ($opt->{output_format} eq 'output_as_rsv') {
        SLUB::LZA::TA::Output::RSV::print_results(\@result);
    } elsif ($opt->{output_format} eq 'output_as_raw') {
        SLUB::LZA::TA::Output::Raw::print_results($aips_response);
    }
    return 1;
}

1;
