package SLUB::LZA::TA::Output::CSV;
use v5.36;

use namespace::autoclean -except => qr{SLUB::LZA::TA::.*};


# VERSION

# ABSTRACT: search IEs module for ta-tool

sub print_results($result_ref) {
    my $headers_ref = SLUB::LZA::TA::Output::get_headers($result_ref);
    binmode(STDOUT, ':encoding(UTF-8)');
    say join(",", map {
        my $l = $_;
        $l=~s/^_//;
        $l=~s/(.*)/"$1"/;
        $l;
    } @{$headers_ref});
    say join("\n", map {
        my $line = $_;
        my $res_line = join(
            ",",
            map {m/^(\d+(\.\d+)?)?$/ ? $_ : "\"$_\""}
            map {$line->{$_} // ""} @{$headers_ref}
        );
        $res_line;
    } @{$result_ref}
    );
    return 1;
}

1;
