package SLUB::LZA::TA::Output::RSV;
use v5.36;
use constant VALUE_TERMINATOR => 0xff;
use constant NULL => 0xfe;
use constant ROW_TERMINATOR => 0xfd;
use constant CHR_VALUE_TERMINATOR => chr(VALUE_TERMINATOR);
use constant CHR_NULL => chr(NULL);
use constant CHR_ROW_TERMINATOR => chr(ROW_TERMINATOR);
use namespace::autoclean -except => qr{SLUB::LZA::TA::.*};

# VERSION

# ABSTRACT: search IEs module for ta-tool


sub print_results($result_ref) {
    my $header_ref = SLUB::LZA::TA::Output::get_headers($result_ref);
    binmode(STDOUT, ':encoding(UTF-8)');
    open (my $cloned_stdout, '>&', STDOUT); # clone STDOUT, allows to switch to alternative encoding without interferring
    binmode($cloned_stdout, ':raw');
    binmode($cloned_stdout, ':bytes');
    local *STDOUT = $cloned_stdout;
    print join(CHR_VALUE_TERMINATOR, map {
        my $l = $_;
        $l =~ s/^_//;
        $l;
    } @{$header_ref}) . CHR_VALUE_TERMINATOR;
    print CHR_ROW_TERMINATOR;
    print join("", map {
        my $line = $_;
        my $res_line = join("", map {
            ($line->{$_} // CHR_NULL) . CHR_VALUE_TERMINATOR
        } @{$header_ref}
        );
        $res_line . CHR_ROW_TERMINATOR;
    } @{$result_ref}
    );
    close $cloned_stdout;
    return 1;
}

1;
