package Test::TA;
use v5.36;
use Path::Tiny;
use Test::Cmd;
use Net::Ping;


sub testhost () {
    return "sdvlzaamtestfotothek01.slub-dresden.de";
}

sub testport () {
    return 9200;
}

sub is_testhost_available () {
    my $ping = Net::Ping->new('tcp');
    $ping->port_number( testport() );
    my $is_avail;
    local $SIG{__WARN__} = sub {1;};
    $is_avail = $ping->ping(testhost());
    $ping->close();
    return $is_avail;
}

{
    my $config_dir;
    my $config_file;
    my $cache_dir;
    my $cache_file;
    my @permanent_volumes;
    sub testapp () {
        # contains common code for tests under t/
        my $perl = $^X;
        my $testapp = Test::Cmd->new(
            prog        => path(__FILE__)->parent->parent->parent->child('bin')->child('ta-tool.pl'),
            workdir     => '',
            subdir      => 'bin',
            #verbose     => 1,
            interpreter => "$perl -I lib/ ",
        );
        $config_dir = path($testapp->workpath())->child('.config');
        $config_dir->mkpath();
        $config_file = $config_dir->child('ta-tool.rc');
        $cache_dir = path($testapp->workpath())->child('.cache');
        $cache_dir->mkpath();
        $cache_file = $cache_dir->child('ta-tool.cache');
        my $testhost = testhost();
        my $testport = testport();
        my $permanent_path = path($testapp->workpath)->child('permanent');
        $permanent_path->mkpath();
        @permanent_volumes = map { $permanent_path->child($_); } qw(foo bar);
        foreach my $vol (@permanent_volumes) {
            $vol->mkpath();
        }
        $config_file->spew_utf8(<<_CFG_);
---
elasticsearch_host: $testhost
elasticsearch_port: $testport
http_only: 1
logdir: /tmp
password: 839852bed005a7f1237578a6ac1197c142f7d0dd58bb248446dc7849d4bf770902e7f980ad83d39008ad638bc41e2345
permanent_volume:
user: lza
_CFG_
        return $testapp;
    }

    sub testconfigfile () {
        return $config_file;
    }
}

1;
