use v5.36;
use Test::Cmd;
use Test::More tests =>10;
use Path::Tiny;
my $perl = $^X;
my $testapp = Test::Cmd->new(
    prog        => path(__FILE__)->parent->parent->child('bin')->child('ta-tool.pl'),
    workdir     => '',
    subdir      => 'bin',
    #verbose     => 1,
    interpreter => "$perl -I lib/ ",
);
# tests
ok($testapp, "init 'ta-tool'");
foreach my $param (qw(--help -h help)) {
    $testapp->run(args => $param);
    like($testapp->stdout, qr/Available commands:/, "ta-tool $param, stdout");
    like($testapp->stderr, qr/^$/, "ta-tool $param, stderr");
    is($? >> 8, 0, "ta-tool $param, exit status");
}
1;
