#!perl
use v5.36;
use Test::Cmd;
use Test::More tests =>6;
use Test::TA;
use Path::Tiny;
$ENV{'TEST_ACTIVE'}=1;
delete $ENV{PERL_MM_USE_DEFAULT};
my $testapp = Test::TA::testapp();
local $ENV{'HOME'} = $testapp->workpath();
my $config_dir = path($testapp->workpath())->child('.config');
$config_dir->mkpath();
my $config_file = $config_dir->child('ta-tool.rc');
my $testhost = Test::TA::testhost();
my $cache_dir = path($testapp->workpath())->child('.cache');
$cache_dir->mkpath();
my $cache_file = $cache_dir->child('ta-tool.cache');
my $permanent_path = path($testapp->workpath)->child('permanent');
my @permanent_volumes = map { $permanent_path->child($_); } qw(foo bar);

# tests
use_ok("SLUB::LZA::TA::Crypt");
is(SLUB::LZA::TA::Crypt::encrypt("199fc76b9d086d8937976634e93413bcd005d941"), "839852bed005a7f1237578a6ac1197c142f7d0dd58bb248446dc7849d4bf770902e7f980ad83d39008ad638bc41e2345", "ta-tool, init, check encryption");
is(SLUB::LZA::TA::Crypt::decrypt("839852bed005a7f1237578a6ac1197c142f7d0dd58bb248446dc7849d4bf770902e7f980ad83d39008ad638bc41e2345"), "199fc76b9d086d8937976634e93413bcd005d941", "ta-tool, init, check encryption");
ok($testapp, "init 'ta-tool'");

subtest 'help check' => sub {
    plan tests => 9;
    foreach my $param ("help init", "init -h", "init --help") {
        $testapp->run(args => $param);
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/this usage screen/, "ta-tool $param, stdout");
        like($testapp->stderr, qr/^$/, "ta-tool $param, stderr");
        is($? >> 8, 0, "ta-tool $param, exit status");
    }
};

subtest 'init check' => sub {
    plan tests => 6;
    $testapp->run(
        stdin => <<_EOF_,
lza
199fc76b9d086d8937976634e93413bcd005d941
199fc76b9d086d8937976634e93413bcd005d941
_EOF_
        args  => 'init -D -v -e ' . $testhost .join("", map {" -P $_"} @permanent_volumes),
        #args  => 'init -e sdvlzaamtestfotothek01.slub-dresden.de -l /tmp',
    );
    #say "STDOUT:",$testapp->stdout;
    #say "STDERR:",$testapp->stderr;
    like($testapp->stdout, qr/User:.*store config in /s, 'ta-tool init, stdout');
    like($testapp->stderr, qr/HINT:/, 'ta-tool init, stderr');
    unlike($testapp->stderr, qr/Error/, 'ta-tool init, stderr indicates no error');
    is($? >> 8, 0, 'ta-tool init, exit status');
    my $config = $config_file->slurp_utf8();
    is($config, <<_EXP_, "ta-tool init, config file as expected");
---
elasticsearch_host: $testhost
elasticsearch_port: 9200
http_only: ~
password: 839852bed005a7f1237578a6ac1197c142f7d0dd58bb248446dc7849d4bf770902e7f980ad83d39008ad638bc41e2345
permanent_volume:
  - $permanent_volumes[0]
  - $permanent_volumes[1]
user: lza
_EXP_
    my $cache = $cache_file->slurp_utf8();
    is($cache, <<_EXP_, "ta-tool init, cache file as expected");
--- {}
_EXP_
};

1;
