#!perl
use v5.36;
use Test::Cmd;
use Test::More tests =>6;
use Test::TA;
my $testapp = Test::TA::testapp();
my $host = Test::TA::testhost();
local $ENV{'HOME'} = $testapp->workpath();
# tests
subtest 'help check' => sub {
    plan tests => 9;
    foreach my $param ("help count", "count -h", "count --help") {
        $testapp->run(args => $param);
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/this usage screen/, "ta-tool $param, stdout");
        like($testapp->stderr, qr/^$/, "ta-tool $param, stderr");
        is($? >> 8, 0, "ta-tool $param, exit status");
    }
};

subtest 'check cli params' => sub {
    plan tests => 3;
    SKIP: {
        skip "testhost '$host' not available", 3 unless Test::TA::is_testhost_available();
        $testapp->run(args => 'count --lzaid SLUB:LZA:goobi:1 --debug');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr//, 'ta-tool count by lzaid, wrong format, stdout');
        like($testapp->stderr, qr/Error: --[a-z].* expects.*Usage/s, 'ta-tool count by lzaid, wrong format, stderr');
        isnt($? >> 8, 0, 'ta-tool count by lzaid, wrong format, exit status');
    };
};


subtest 'elastic count existing lza id' => sub {
    plan tests => 6;
    SKIP: {
        skip "testhost '$host' not available", 6 unless Test::TA::is_testhost_available();
        $testapp->run(args => 'count --lzaid SLUB:LZA:testworkflow:testcases:test-sip_2023-01-01-11_11-11_11111 --debug');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^1$/s, 'ta-tool count by lzaid, existing, stdout');
        like($testapp->stderr, qr/\A\@must=.*/, 'ta-tool count by lzaid, existing, stderr');
        is($? >> 8, 0, 'ta-tool count by lzaid, no match, exit status');
        $testapp->run(args => 'count --lzaid SLUB:LZA:testworkflow:testcases:test-sip_2023-01-01-11_11-11_11111');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^1$/s, 'ta-tool count by lzaid, existing, stdout');
        like($testapp->stderr, qr/^$/, 'ta-tool count by lzaid, existing, stderr');
        is($? >> 8, 0, 'ta-tool count by lzaid, existing, exit status');
    };
};

subtest 'elastic count existing dc entry' => sub {
    plan tests => 3;
    SKIP: {
        skip "testhost '$host' not available", 3 unless Test::TA::is_testhost_available();
        $testapp->run(args => 'count --descriptive "Retrodigitalisierte Fotosn"'); #SLUB:LZA:testworkflow:testcases:test-sip_2023-01-01-11_11-11_11111');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^30$/, 'ta-tool count by dc, existing, stdout');
        like($testapp->stderr, qr/^$/, 'ta-tool count by dc, existing, stderr');
        is($? >> 8, 0, 'ta-tool count by lzaid, existing, exit status');
    };
};

subtest 'elastic count dates' => sub {
    plan tests => 6;
    SKIP: {
        skip "testhost '$host' not available", 6 unless Test::TA::is_testhost_available();
        $testapp->run(args => 'count --creationdate 2023-09-05');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^2$/, 'ta-tool count date, existing, stdout');
        like($testapp->stderr, qr/^$/, 'ta-tool count date, existing, stderr');
        is($? >> 8, 0, 'ta-tool count date, existing, exit status');

        $testapp->run(args => 'count --creationdate-from 2023-09-05 --creationdate-to 2023-12-22');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^25$/, 'ta-tool count dates, existing, stdout');
        like($testapp->stderr, qr/^$/, 'ta-tool count dates, existing, stderr');
        is($? >> 8, 0, 'ta-tool count dates, existing, exit status');
    };
};

subtest 'overrides' => sub {
    plan tests => 3;
    SKIP: {
        skip "testhost '$host' not available", 3 unless Test::TA::is_testhost_available();
        $testapp->run(args => 'count --elasticsearch-host localhost --creationdate-from 2023-09-05 --creationdate-to 2023-12-22');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^$/, 'ta-tool count dates, existing, override, stdout');
        like($testapp->stderr, qr/^Hint: override local config with/, 'ta-tool count dates, existing, override, stderr');
        is($? >> 8, 111, 'ta-tool count dates, existing, override, exit status');
    };
};

1;
