#!perl
use v5.36;
use Test::Cmd;
use Test::More tests =>3;
use Test::TA;
my $testapp = Test::TA::testapp();
my $host = Test::TA::testhost();
local $ENV{'HOME'} = $testapp->workpath();
# tests
subtest 'help check' => sub {
    plan tests => 9;
    foreach my $param ("help info", "info -h", "info --help") {
        $testapp->run(args => $param);
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/this usage screen/, "ta-tool $param, stdout");
        like($testapp->stderr, qr/^$/, "ta-tool $param, stderr");
        is($? >> 8, 0, "ta-tool $param, exit status");
    }
};

subtest 'elastic search version' => sub {
    plan tests => 3;
    SKIP: {
        skip "testhost '$host' not available", 3 unless Test::TA::is_testhost_available();
        $testapp->run(args => 'info --target-version');
        like($testapp->stdout, qr/^6\.\d\.\d{1,2}$/, 'ta-tool elasticsearch version, stdout');
        like($testapp->stderr, qr/^$/, 'ta-tool elasticsearch version, stderr');
        is($? >> 8, 0, 'ta-tool elasticsearch version, exit status');
    };
};

subtest 'overrides' => sub {
    plan tests => 3;
    SKIP: {
        skip "testhost '$host' not available", 3 unless Test::TA::is_testhost_available();
        $testapp->run(args => 'info --elasticsearch-host localhost --target-version');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^$/, 'ta-tool elasticsearch version, override, stdout');
        like($testapp->stderr, qr/^Hint: override local config/, 'ta-tool elasticsearch version, override, stderr');
        is($? >> 8, 111, 'ta-tool elasticsearch version, override, exit status');
    };
};

1;
