#!perl
use v5.36;
use Test::Cmd;
use Test::More tests => 4;
use Test::TA;
use Archive::Tar;
use Path::Tiny;
my $testapp = Test::TA::testapp();
my $path_valid = path($testapp->workpath)->child("valid");
my $path_invalid = path($testapp->workpath)->child("invalid");
$path_valid->mkdir();
$path_invalid->mkdir();
my $tar = Archive::Tar->new();
my $tarpath = path(__FILE__)->absolute->parent->child("/../testdata.tgz");
say $tarpath;
$tar->read($tarpath);
$tar->setcwd($path_valid);
$tar->extract();
$tar->setcwd($path_invalid);
$tar->extract();
$path_invalid->visit( # patch files to get invalid bags
    sub {
        my ($path, $state) = @_;
        if ($path =~ m/bag-info.txt$/) {
            $path->append_utf8("Payload-Oxum: 0.0");
        }
        1;
    },
        {recurse => 1 }
);

local $ENV{'HOME'} = $testapp->workpath();
# tests
subtest 'help check' => sub {
    plan tests => 9;
    foreach my $param ("help permanent", "permanent -h", "permanent --help") {
        $testapp->run(args => $param);
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/this usage screen/, "ta-tool $param, stdout");
        like($testapp->stderr, qr/^$/, "ta-tool $param, stderr");
        is($? >> 8, 0, "ta-tool $param, exit status");
    }
};

subtest 'check permanent volumes' => sub {
    plan tests => 3;
    $testapp->run(args => 'permanent');
    #say "STDOUT:",$testapp->stdout;
    #say "STDERR:",$testapp->stderr;
    like($testapp->stdout, qr/\n:doctype: article/s, 'ta-tool permanent, stdout');
    like($testapp->stderr, qr/^scanning volumes/, 'ta-tool permanent, stderr');
    is($? >> 8, 0, 'ta-tool permanent, exit status');
};

subtest 'overrides, valid' => sub {
    $testapp->run(args => "permanent --permanent-volume $path_valid");
    #say "STDOUT:",$testapp->stdout;
    #say "STDERR:",$testapp->stderr;
    like($testapp->stdout, qr/\n"AIP storage path","bagit validation result"\n.*,"valid"\n/s, 'ta-tool permanent, override, stdout');
    like($testapp->stderr, qr/^Hint: override local config.*\nscanning volumes:.*\bvalid/s, 'ta-tool permanent, override, stderr');
    is($? >> 8, 0, 'ta-tool permanent, override, exit status');
};

subtest 'overrides, invalid' => sub {
    $testapp->run(args => "permanent --permanent-volume $path_invalid");
    #say "STDOUT:",$testapp->stdout;
    #say "STDERR:",$testapp->stderr;
    like($testapp->stdout, qr/\n"AIP storage path","bagit validation result"\n.*,"invalid"\n/s, 'ta-tool permanent, override, stdout');
    like($testapp->stderr, qr/^Hint: override local config.*\nscanning volumes:.*\binvalid/s, 'ta-tool permanent, override, stderr');
    is($? >> 8, 0, 'ta-tool permanent, override, exit status');
};


1;
