#!perl
use v5.36;
use Test::Cmd;
use Test::More tests => 3;
use Path::Tiny;
use Test::TA;
my $testapp = Test::TA::testapp();
my $host = Test::TA::testhost();
local $ENV{'HOME'} = $testapp->workpath();
# tests
subtest 'help check' => sub {
    plan tests => 9;
    foreach my $param ("help report", "report -h", "report --help") {
        $testapp->run(args => $param);
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/this usage screen/, "ta-tool $param, stdout");
        like($testapp->stderr, qr/^$/, "ta-tool $param, stderr");
        is($? >> 8, 0, "ta-tool $param, exit status");
    }
};

subtest 'check cli params' => sub {
    plan tests => 15;
    SKIP: {
        skip "testhost '$host' not available", 15 unless Test::TA::is_testhost_available();
        $testapp->run(args => 'report');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^:lang: en\n:doctype: article\n:date:.*\n:generator:.*\n:toc:\n\n= Report from.*\n\n== Complete archive\n\n=== count/s, 'ta-tool report, base, stdout');
        like($testapp->stderr, qr/^reporting for period/s, 'ta-tool report, base, stderr');
        is($? >> 8, 0, 'ta-tool report, base, exit status');

        $testapp->run(args => 'report --output-as-csv');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^"set","subset","timespan_from","timespan_to","aip_state","filter","flavour","value"\n"([a-z]+)",,"\d{4}-\d{2}-\d{2}","\d{4}-\d{2}-\d{2}","([a-z ]+)",,"([a-z ]+)",\d+(\.\d+)?\n/s, 'ta-tool report, base as CSV, stdout');
        like($testapp->stderr, qr/^reporting for period/s, 'ta-tool report, base as CSV, stderr');
        is($? >> 8, 0, 'ta-tool report, base as CSV, exit status');

        $testapp->run(args => 'report --output-as-csv --with-ldp');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^"set","subset","timespan_from","timespan_to","aip_state","filter","flavour","value"\n.*LDP/s, 'ta-tool report, with ldp, stdout');
        like($testapp->stderr, qr/^reporting for period.*HINT:.*with-ldp/s, 'ta-tool report, with ldp, stderr');
        is($? >> 8, 0, 'ta-tool report, with ldp, exit status');

        $testapp->run(args => 'report --output-as-csv --with-filetypes');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^"set","subset","timespan_from","timespan_to","aip_state","filter","flavour","value"\n.*total/s, 'ta-tool report, with filetype, stdout');
        like($testapp->stderr, qr/^reporting for period.*HINT:.*with-filetype/s, 'ta-tool report, with filetype, stderr');
        is($? >> 8, 0, 'ta-tool report, with filetype, exit status');

        $testapp->run(args => 'report --output-as-csv --with-ldp --with-filetypes');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^"set","subset","timespan_from","timespan_to","aip_state","filter","flavour","value"\n.*LDP/s, 'ta-tool report, with ldp and filetypes, stdout');
        like($testapp->stderr, qr/^reporting for period.*HINT:.*with-ldp.*with-filetype/s, 'ta-tool report, with ldp and filetypes, stderr');
        is($? >> 8, 0, 'ta-tool report, with ldp and filetypes, exit status');
    };
};


subtest 'overrides' => sub {
    plan tests => 3;
    SKIP: {
        skip "testhost '$host' not available", 3 unless Test::TA::is_testhost_available();
        $testapp->run(args => 'report --elasticsearch-host localhost');
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/^$/s, 'ta-tool report, base, stdout');
        like($testapp->stderr, qr/^Hint: override local config with/s, 'ta-tool report, base, stderr');
        is($? >> 8, 111, 'ta-tool report, base, exit status');
    };
};
1;
