#!perl
use v5.36;
use Test::Cmd;
use Test::More tests => 3;
use Test::TA;
use Path::Tiny;
my $testapp = Test::TA::testapp();
my $path = path($testapp->workpath)->child("mnt");
$path->mkdir();

local $ENV{'HOME'} = $testapp->workpath();
# tests
subtest 'help check' => sub {
    plan tests => 9;
    foreach my $param ("help sample_testing", "sample_testing -h", "sample_testing --help") {
        $testapp->run(args => $param);
        #say "STDOUT:",$testapp->stdout;
        #say "STDERR:",$testapp->stderr;
        like($testapp->stdout, qr/this usage screen/, "ta-tool $param, stdout");
        like($testapp->stderr, qr/^$/, "ta-tool $param, stderr");
        is($? >> 8, 0, "ta-tool $param, exit status");
    }
};

subtest 'check sample_testing volumes' => sub {
    plan tests => 3;
    $testapp->run(args => 'sample_testing');
    #say "STDOUT:",$testapp->stdout;
    #say "STDERR:",$testapp->stderr;
    like($testapp->stdout, qr/\n:doctype: article/s, 'ta-tool sample_testing, stdout');
    like($testapp->stderr, qr/\nscanning volumes/s, 'ta-tool sample_testing, stderr');
    is($? >> 8, 0, 'ta-tool sample_testing, exit status');
};

subtest 'overrides, path' => sub {
    $testapp->run(args => "sample_testing --permanent-volume $path");
    #say "STDOUT:",$testapp->stdout;
    #say "STDERR:",$testapp->stderr;
    like($testapp->stdout, qr/Path is/, 'ta-tool sample_testing, override, stdout');
    like($testapp->stderr, qr/^Hint: override local config.*\nscanning volumes:/s, 'ta-tool sample_testing, override, stderr');
    is($? >> 8, 0, 'ta-tool sample_testing, override, exit status');
};

1;
