use strict;
use warnings;
use Test::More;
use File::Find;
use Path::Tiny;


#search all modules as file paths
my @modules;
sub wanted {
    $File::Find::name=~ m#SLUB/LZA/.+\.pm$# && -f $_ && push @modules, $File::Find::name;
}
find(\&wanted, "lib/");

foreach my $module (@modules) {
    my $content = path( $module )->slurp;
    if ($content =~ m/^use v5\.(\d\d);/m and $1 < 36 ) {
        fail("module $module has 'use v5.$1;', you should use 'use feature qw(...);' instead.");
    } else {
        pass("module $module is fine.");
    }
}

done_testing();
1;
